package com.ht.es;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;

import rx.Observable;
import rx.functions.Func1;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.JsonDocument;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ht.vo.Customer;
 

/**
 * 
 * Written By : Henry Potsangbam
 * Dated : 6th July 2015
 * Description: Main Program for performing Views operation using JAVA SDK
 * 
 * 
 */

public class LearningCouchbaseESView {

	public static void main(String[] args) {
		 try {
	  	  String url="http://localhost:9200/learningcouchbase/_search?pretty=true&q=skills:Couchbase+name:Henry";
		  String resultStr = fetchESQuery(url);
		   boESQuery(getDocIDs(resultStr));
		} catch (Exception e) {
			e.printStackTrace();
		}
		 
		 
	}

	
	static void boESQuery(Collection<String> dociDs) {
		Cluster cluster = CouchbaseCluster.create("localhost");
		final Bucket  bucket = cluster.openBucket("LearningCouchbase");
		List<JsonDocument> docs = bulkGet(dociDs, bucket);
		
		Gson gson = new GsonBuilder().create();
		for (JsonDocument doc : docs) {
			Customer cust = gson.fromJson(doc.content().toString(), Customer.class);
			System.out.println(cust);
		}
		
	}

	static Collection<String> getDocIDs(String resultStr) throws JsonProcessingException, IOException {
		 
		byte[] jsonData = resultStr.getBytes();
		 
		//create ObjectMapper instance
		ObjectMapper objectMapper = new ObjectMapper();
		 
		//read JSON like DOM Parser
		JsonNode rootNode = objectMapper.readTree(jsonData);
		 
		JsonNode docListNode = rootNode.path("hits").path("hits");
		
		List<String> docList = new ArrayList<String>();
		Iterator<JsonNode> elements = docListNode.elements();
		while(elements.hasNext()){
		    JsonNode doc = elements.next().get("_id");
		    docList.add(doc.asText());
		}
		return docList;
	    
	}
	
	static String fetchESQuery(String url) throws Exception {
		HttpGet request = new HttpGet(url);
		HttpClient client = HttpClientBuilder.create().build();
		HttpResponse response = client.execute(request);
		 
	  BufferedReader rd = new BufferedReader(
	                new InputStreamReader(response.getEntity().getContent()));
	 
		StringBuffer result = new StringBuffer();
		String line = "";
		while ((line = rd.readLine()) != null) {
			result.append(line);
		}
	  
		return result.toString();
	}
	
	public static List<JsonDocument> bulkGet(final Collection<String> ids,final Bucket bucket) {
	    return Observable
	        .from(ids)
	        .flatMap(new Func1<String, Observable<JsonDocument>>() {
	            
	            public Observable<JsonDocument> call(String id) {
	                return bucket.async().get(id);
	            }
	        })
	        .toList()
	        .toBlocking()
	        .single();
	}
	}
